-- Edward



set sql_safe_updates=0;


-- APPROVE_APPLICATION        
SET @approveApplication=(SELECT id FROM dtprovider WHERE `dataProviderName`='APPROVE_APPLICATION_RECIPIENTS');

UPDATE `sql_dtprovider` SET `sqlQuery`="select T1.id AS ID,
    T3.`salutationName` AS SALUTATION_NAME,
    T2.`firstName` AS FIRST_NAME,
    T2.`middleName` AS MIDDLE_NAME,
    T2.`lastName` AS LAST_NAME,
    T2.`emailId` AS EMAIL_ID,
    T2.`mobileNumber` AS MOBILE_NO,
    T1.`code` as APPLICATION_CODE,
	ml.code as LANGUAGE_KEY,
    (CASE
        WHEN
            T5.headerUrl IS NOT NULL
                AND org.orgUrl IS NOT NULL
        THEN
            CONCAT(org.orgUrl, '/', T5.headerUrl)
        ELSE NULL
    END) AS HEADER_URL,
    (Case 
        when 
            T5.footerUrl is not null 
                and org.orgUrl IS NOT NULL 
        then 
            CONCAT(org.orgUrl, '/', T5.footerUrl)
        else NULL 
    end) as FOOTER_URL 
    from application T1 
    left outer join applicant_person T2 on T1.applicantPersonId=T2.id
    left outer join salutations T3 on T3.id = T2.salutationId
    LEFT OUTER JOIN
    application_program T4 ON T4.applicationId = T1.id
        LEFT OUTER JOIN
    academy_location T5 ON T5.id = T4.academyLocationId
        LEFT OUTER JOIN
    organizations org ON org.id = (SELECT 
            MAX(id)
        FROM
            organizations)
	left outer join multi_language ml on ml.id=T2.correspondence_language
    where T1.id in(namedParams)" WHERE `dataProviderId`=@approveApplication;  
    
    
-- REJECT_APPLICATION        
SET @rejectApplication=(SELECT id FROM dtprovider WHERE `dataProviderName`='REJECT_APPLICATION_RECIPIENTS');

UPDATE `sql_dtprovider` SET `sqlQuery`="select T1.id AS ID,
	T3.`salutationName` AS SALUTATION_NAME,
	T2.`firstName` AS FIRST_NAME,
	T2.`middleName` AS MIDDLE_NAME,
	T2.`lastName` AS LAST_NAME,
	T2.`emailId` AS EMAIL_ID,
	T2.`mobileNumber` AS MOBILE_NO,
    T1.`code` as APPLICATION_CODE,
	T2.`mobileCountryCode` AS MOBILE_CODE,
	ml.`code` as LANGUAGE_KEY
    from application T1 
    left outer join applicant_person T2 on T1.applicantPersonId=T2.id
    LEFT join salutations T3 on T3.id = T2.salutationId
    LEFT join multi_language ml on ml.id = T2.correspondence_language
    where T1.id in(namedParams)" WHERE `dataProviderId`=@rejectApplication;  
 
 
 -- APPROVE_ADMISSION        

SET @approveAdmission=(SELECT id FROM dtprovider WHERE `dataProviderName`='APPROVE_ADMISSION_APPLICANT_INFO');

UPDATE `sql_dtprovider` SET `sqlQuery`="SELECT 
T2.id AS ID,
T3.`salutationName` AS SALUTATION_NAME,
T2.`firstName` AS FIRST_NAME,
T2.`middleName` AS MIDDLE_NAME,
T2.`lastName` AS LAST_NAME,
T2.`emailId` AS EMAIL_ID,
T2.`mobileNumber` AS MOBILE_NO,
T2.`mobileCountryCode` AS MOBILE_CODE,
ml.`code` as LANGUAGE_KEY
FROM `application`  T1 
INNER JOIN
 `applicant_person` T2 ON T2.id = T1.applicantPersonId
 LEFT JOIN 
 `salutations` T3 ON T3.`id`=T2.`salutationId`
LEFT JOIN
  multi_language ml on ml.id = T2.correspondence_language
  
 WHERE T2.id IN (namedParams)"  WHERE `dataProviderId`=@approveAdmission;                 

-- SUBMIT_APPLICATION        
SET @submitApplication=(SELECT id FROM dtprovider WHERE `dataProviderName`='SUBMIT_APPLICATION_RECIPIENTS');

UPDATE `sql_dtprovider` SET `sqlQuery`="SELECT 
        T1.id AS ID,
        T3.`salutationName` AS SALUTATION_NAME,
        T8.`salutationName` AS PARENT_SALUTATION_NAME,
        T2.`firstName` AS FIRST_NAME,
        T2.`middleName` AS MIDDLE_NAME,
		T2.`printName` AS STUDENT_PRINT_NAME,
        T2.`lastName` AS LAST_NAME,
        T7.`emailId` AS EMAIL_ID,
        T7.`mobileNumber` AS MOBILE_NO,
        T1.`code` AS APPLICATION_CODE,
        T7.`firstName` AS PARENT_FIRSTNAME,
        T7.`lastName` AS PARENT_LASTNAME,
		T7.`printName` AS PARENT_PRINT_NAME,
        T7.`mobileCountryCode` AS MOBILE_CODE  ,
        ml.`code` as LANGUAGE_KEY
    FROM
        application T1
            LEFT OUTER JOIN
        applicant_person T2 ON T1.applicantPersonId = T2.id
            LEFT JOIN
        salutations T3 ON T3.id = T2.salutationId
            LEFT OUTER JOIN
        external_user_association T5 ON T5.applicationId = T1.id
            LEFT OUTER JOIN
        external_users T4 ON T4.id = T5.externalUserId
            LEFT OUTER JOIN
        applicant_person_relationships T6 ON T6.applicantPersonId = T2.id
            LEFT OUTER JOIN
        applicant_person T7 ON T7.id = T6.relatedApplicantPersonId
            LEFT JOIN
        salutations T8 ON T8.id = T7.salutationId
         LEFT JOIN
        multi_language ml on ml.id = T2.correspondence_language
    WHERE
        T1.id IN (namedParams)
            AND T6.relationship = 'FATHER'
            " WHERE `dataProviderId`=@submitApplication;  
            
-- APPLICANT_LOGIN_CREDENTIAL_INFO        
SET @applicantLoginCredential=(SELECT id FROM dtprovider WHERE `dataProviderName`='APPLICANT_LOGIN_CREDENTIAL_INFO');

UPDATE `sql_dtprovider` SET `sqlQuery`="select T1.id as ID,
	T4.`firstName` AS FIRST_NAME,
	T4.`lastName` AS LAST_NAME,
    T4.`emailId` AS EMAIL_ID,
	T4.`mobileNumber` AS MOBILE_NO,
	T4.`mobileCountryCode` AS MOBILE_CODE,
     ml.code as LANGUAGE_KEY
 from external_users T1
	left join external_user_association T2 on T2.externalUserId=T1.id
    left join application T3 on T3.id=T2.applicationId
    left join applicant_person T4 on T4.id=T3.applicantPersonId 
     LEFT JOIN
    multi_language ml on T4.correspondence_language=ml.id
    where T1.id in (namedParams)" WHERE `dataProviderId`=@applicantLoginCredential;  
                 
     		
-- MSG_COURSEWISE_WEEKLY_ATTENDACE_PARENT_REPORT        
SET @msgCoursewiseWeekAttendanceParent=(SELECT id FROM dtprovider WHERE `dataProviderName`='MSG_COURSEWISE_WEEKLY_ATTENDANCE_PARENT_RCPNT');

UPDATE `sql_dtprovider` SET `sqlQuery`="SELECT 
    T13.id AS ID,   
    T7.firstName AS FIRST_NAME,
    T7.lastName AS LAST_NAME,
    T16.code AS STUDENT_CODE,
    T13.firstName AS PARENT_FIRST_NAME,
    T13.lastName AS PARENT_LAST_NAME,
    T13.emailId AS EMAIL_ID,
    T13.mobileNumber AS MOBILE_NO,
    T13.mobilecountrycode AS MOBILE_CODE,
    cou.nameToBePrinted AS COURSE_NAME,
    cou.courseCode AS COURSE_CODE,   
    T9.firstName AS FACULTY_FIRSTNAME,
    T9.lastName AS FACULTY_LASTNAME,
    T10.salutationName AS SALUTATION,
    T15.salutationName AS PARENT_SALUTATION,
    bch.batchName AS BATCH_NAME,
    prg.programNameToBePrint AS PROGRAM_NAME,
    per.programPeriodName AS PERIOD_NAME,
    T18.displayName AS ACADEMY_NAME,    
	ml.`code` as LANGUAGE_KEY,
    COUNT(IF(scad.attendanceStatus = 'PRESENT',
        scad.attendanceStatus,
        NULL)) + COUNT(IF(scad.attendanceStatus <> 'PRESENT',
        scad.attendanceStatus,
        NULL)) AS `TOTAL_SESSIONS`,
    COUNT(IF(scad.attendanceStatus = 'PRESENT',
        scad.attendanceStatus,
        NULL)) AS `TOTAL_PRESENT`,
    COUNT(IF(scad.attendanceStatus = 'ABSENT',
        scad.attendanceStatus,
        NULL)) AS `TOTAL_ABSENT`,
    COUNT(IF(scad.attendanceStatus = 'LEAVE',
        scad.attendanceStatus,
        NULL)) AS `TOTAL_LEAVE`,
    ROUND((COUNT(IF(scad.attendanceStatus = 'PRESENT',
                scad.attendanceStatus,
                NULL)) / (COUNT(IF(scad.attendanceStatus = 'PRESENT',
                scad.attendanceStatus,
                NULL)) + COUNT(IF(scad.attendanceStatus <> 'PRESENT',
                scad.attendanceStatus,
                NULL)))) * 100) AS `PRESENT_PERCENTAGE`
                from student_course_enrollment sce
join prog_batch_period_config per 
on per.id = sce.programBatchPeriodConfigId
join admission adm 
on adm.id = sce.admissionId
join batches bch on bch.id = per.programBatchId
join programs prg on prg.id=  bch.programId
join course_variants cv on cv.id = sce.courseVarientId
join courses cou on cou.id = cv.courseId or cou.parentCourseId = cv.courseId
join program_batch_course_param param on param.courseVarientId = cv.id
join prog_batch_course_faculty fac on fac.progBatchCourseParamId =  param.id
left join student_course_attendance sca on sca.variantId = sce.courseVarientId
left join student_course_attendance_details scad on scad.attendanceId = sca.id and adm.id = scad.admissionId
LEFT JOIN
	users T16 ON T16.id = adm.studentId
LEFT JOIN
    students T6 ON T6.userId = T16.id
        LEFT JOIN
    persons T7 ON T7.id = T6.personId
        LEFT JOIN
    staffs T8 ON T8.userId = fac.facultyId
        LEFT JOIN
    persons T9 ON T9.id = T8.personId
        LEFT JOIN
    salutations T10 ON T10.id = T9.salutationId
        LEFT JOIN
    person_relationships T12 ON T12.personId = T7.id
        LEFT JOIN
    persons T13 ON T13.id = T12.relatedPersonId
		LEFT JOIN
    salutations T15 ON T15.id = T13.salutationId
        LEFT JOIN
    academy_location T18 ON T18.id = prg.academyLocationId
     LEFT JOIN
     multi_language ml ON ml.id = T7.correspondence_language
where per.isCurrentPeriodOfProgram = 1 and T13.id IN (namedParams)
and sce.exitDate is null
GROUP BY cv.courseId , sce.sectionId , sce.courseVarientId , adm.studentId,T13.id
ORDER BY cv.courseId DESC" WHERE `dataProviderId`=@msgCoursewiseWeekAttendanceParent;


-- APPLICANT_FORM_SUBMIT_RECIPIENTS        
SET @applicantFormSubmit=(SELECT id FROM dtprovider WHERE `dataProviderName`='APPLICANT_FORM_SUBMIT_RECIPIENTS');

UPDATE `sql_dtprovider` SET `sqlQuery`="select T1.id AS ID,
T2.`firstName` AS FIRST_NAME,
T2.`middleName` AS MIDDLE_NAME,
T2.`lastName` AS LAST_NAME,
T2.`emailId` AS EMAIL_ID,
T2.`mobileNumber` AS MOBILE_NO,
T1.`code` as APPLICATION_CODE,
T2.`mobileCountryCode` as MOBILE_CODE,
T2.`alternateEmailId` as ALTERNATE_EMAIL_ID,
 ml.`code` as LANGUAGE_KEY
from application T1 
left outer join applicant_person T2 on T1.applicantPersonId=T2.id
left outer join
external_user_association T5 on T5.applicationId = T1.id 
left outer join
external_users T4 on T4.id = T5.externalUserId 
left outer join
multi_language ml ON ml.id = T2.correspondence_language
where T1.id in (namedParams)" WHERE `dataProviderId`=@applicantFormSubmit;



-- SUBMIT_APPLICATION_PAY_LATER_BUZZ_RECIPIENT        
SET @submitApplicationPaylaterBuzz=(SELECT id FROM dtprovider WHERE `dataProviderName`='SUBMIT_APPLICATION_PAY_LATER_BUZZ_RECIPIENT');

UPDATE `sql_dtprovider` SET `sqlQuery`="select T1.id AS ID,
T2.`firstName` AS FIRST_NAME,
T2.`middleName` AS MIDDLE_NAME,
T2.`lastName` AS LAST_NAME,
T2.`emailId` AS EMAIL_ID,
T2.`mobileNumber` AS MOBILE_NO,
T1.`code` as APPLICATION_CODE,
T2.`mobileCountryCode` as MOBILE_CODE,
T2.`alternateEmailId` as ALTERNATE_EMAIL_ID,
 ml.`code` as LANGUAGE_KEY
from application T1 
left outer join applicant_person T2 on T1.applicantPersonId=T2.id
left outer join
external_user_association T5 on T5.applicationId = T1.id 
left outer join
external_users T4 on T4.id = T5.externalUserId 
left outer join
multi_language ml ON ml.id = T2.correspondence_language
where T1.id in (namedParams)" WHERE `dataProviderId`=@submitApplicationPaylaterBuzz;

-- SUBMIT_APPLICATION_PAY_NOW_BUZZ_RECIPIENT        
SET @submitApplicationPayNowBuzz=(SELECT id FROM dtprovider WHERE `dataProviderName`='SUBMIT_APPLICATION_PAY_NOW_BUZZ_RECIPIENT');

UPDATE `sql_dtprovider` SET `sqlQuery`="SELECT 
    T1.id AS ID,
    T4.`firstName` AS FIRST_NAME,
    T4.`lastName` AS LAST_NAME,
    T4.`emailId` AS EMAIL_ID,
    T4.`mobileNumber` AS MOBILE_NO,
    T3.`code` AS APPLICATION_CODE,
    T8.displayName AS ACADEMY_NAME_LOCATION,
    T8.academyName AS ACADEMY_NAME,
    ml.`code` as LANGUAGE_KEY,
    (CASE
        WHEN
            T8.logoUrl IS NULL
                AND org.orgUrl IS NOT NULL
        THEN
            CONCAT(org.orgUrl,
                    '/',
                    'emailer/images/logo_default_image.png')
        WHEN
            T8.logoUrl IS NULL
                AND org.orgUrl IS NULL
        THEN
            'https://www.serosoft.com/mailer/academiaerp_logo_red.png'
        ELSE CONCAT(org.orgUrl, '/', T8.logoUrl)
    END) AS LOGO_URL,
    (CASE
        WHEN
            T8.headerUrl IS NOT NULL
                AND org.orgUrl IS NOT NULL
        THEN
            CONCAT(org.orgUrl, '/', T8.headerUrl)
        ELSE NULL
    END) AS HEADER_URL,
    (Case 
        when 
            T8.footerUrl is not null 
                and org.orgUrl IS NOT NULL 
        then 
            CONCAT(org.orgUrl, '/', T8.footerUrl)
        else NULL 
    end) as FOOTER_URL
FROM
    external_users T1
        LEFT JOIN
    external_user_association T2 ON T2.externalUserId = T1.id
        LEFT JOIN
    application T3 ON T3.id = T2.applicationId
        LEFT JOIN
    applicant_person T4 ON T4.id = T3.applicantPersonId
        LEFT OUTER JOIN
    application_program T7 ON T7.applicationId = T3.id
        LEFT OUTER JOIN
    academy_location T8 ON T8.id = T7.academyLocationId
        LEFT OUTER JOIN
    organizations org ON org.id = (SELECT 
            MAX(id)
        FROM
            organizations)
	    LEFT JOIN
     multi_language ml ON ml.id = T4.correspondence_language
                
WHERE
    T1.id IN (namedParams)" WHERE `dataProviderId`=@submitApplicationPayNowBuzz;


-- SUBMIT_APPLICATION_PAY_NOW_BUZZ_PARENT_RECIPIENT        
SET @submitApplicationPayNowBuzzParent=(SELECT id FROM dtprovider WHERE `dataProviderName`='SUBMIT_APPLICATION_PAY_NOW_BUZZ_PARENT_RECIPIENT');

UPDATE `sql_dtprovider` SET `sqlQuery`="SELECT 
    T1.id AS ID,
    T4.`firstName` AS FIRST_NAME,
    T4.`lastName` AS LAST_NAME,
    T6.`emailId` AS EMAIL_ID,
    T6.`mobileNumber` AS MOBILE_NO,
    T6.`mobileCountryCode` AS MOBILE_CODE,
    T6.`firstName` AS PARENT_FIRSTNAME,
    T6.`lastName` AS PARENT_LASTNAME,
    T3.`code` AS APPLICATION_CODE,
    T8.displayName AS ACADEMY_NAME_LOCATION,
    T8.academyName AS ACADEMY_NAME,
     ml.code as LANGUAGE_KEY,
    (CASE
        WHEN
            T8.logoUrl IS NULL
                AND org.orgUrl IS NOT NULL
        THEN
            CONCAT(org.orgUrl,
                    '/',
                    'emailer/images/logo_default_image.png')
        WHEN
            T8.logoUrl IS NULL
                AND org.orgUrl IS NULL
        THEN
            'https://www.serosoft.com/mailer/academiaerp_logo_red.png'
        ELSE CONCAT(org.orgUrl, '/', T8.logoUrl)
    END) AS LOGO_URL,
    (CASE
        WHEN
            T8.headerUrl IS NOT NULL
                AND org.orgUrl IS NOT NULL
        THEN
            CONCAT(org.orgUrl, '/', T8.headerUrl)
        ELSE NULL
    END) AS HEADER_URL,
    (Case 
        when 
            T8.footerUrl is not null 
                and org.orgUrl IS NOT NULL 
        then 
            CONCAT(org.orgUrl, '/', T8.footerUrl)
        else NULL 
    end) as FOOTER_URL
FROM
    external_users T1
        LEFT JOIN
    external_user_association T2 ON T2.externalUserId = T1.id
        LEFT JOIN
    application T3 ON T3.id = T2.applicationId
        LEFT JOIN
    applicant_person T4 ON T4.id = T3.applicantPersonId
        LEFT OUTER JOIN
    applicant_person_relationships T5 ON T5.applicantPersonId = T4.id
        LEFT JOIN
    applicant_person T6 ON T6.id = T5.relatedApplicantPersonId
        LEFT JOIN
    application_program T7 ON T7.applicationId = T3.id
        LEFT OUTER JOIN
    academy_location T8 ON T8.id = T7.academyLocationId
        LEFT OUTER JOIN
    organizations org ON org.id = (SELECT 
            MAX(id)
        FROM
            organizations)
     LEFT JOIN       
     multi_language ml on T4.correspondence_language=ml.id          
WHERE
    T1.id IN (namedParams) AND T5.relationship = 'FATHER'" WHERE `dataProviderId`=@submitApplicationPayNowBuzzParent;


set sql_safe_updates=1;

